<?php
use App\Color;
?>
<!DOCTYPE html>
<html lang="en" dir="ltr">
<head>
    <!-- TITLE -->
    <title><?php echo e($settings->website_name ?? 'DigiMarket'); ?> - Digital Marketplace</title>

    <!-- Meta -->
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <meta name="author" content="<?php echo e($settings->website_name ?? 'DigiMarket'); ?>">
    <meta name="robots" content="">
    <meta name="keywords" content="digital marketplace, digital products, creative, professional, responsive, web design, web development">
    <meta name="description" content="<?php echo e($settings->website_name ?? 'DigiMarket'); ?> - Professional Digital Marketplace for <?php echo e($settings->website_content_name ?? 'Digital Products'); ?>">
    <meta property="og:title" content="<?php echo e($settings->website_name ?? 'DigiMarket'); ?> - Digital Marketplace">
    <meta property="og:description" content="<?php echo e($settings->website_name ?? 'DigiMarket'); ?> - Professional Digital Marketplace for <?php echo e($settings->website_content_name ?? 'Digital Products'); ?>">
    <meta name="format-detection" content="telephone=no">

    <!-- Mobile Specific -->
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- Favicon icon -->
    <link rel="icon" type="image/png" href="<?php echo e(asset('assets/images/favicon.png')); ?>">

    <!-- Stylesheet -->
    <link href="<?php echo e(asset('assets/vendor/niceselect/css/nice-select.css')); ?>" rel="stylesheet">

    <!-- ICONS CSS -->
    <link href="<?php echo e(asset('assets/icons/flaticon/flaticon.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/icons/line-awesome/css/line-awesome.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/icons/font-awesome/css/all.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/icons/themify/themify-icons.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/vendor/magnific-popup/magnific-popup.min.css')); ?>" rel="stylesheet">

    <!-- STYLESHEETS -->
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/vendor/swiper/swiper-bundle.min.css')); ?>">
    <link href="<?php echo e(asset('assets/vendor/owl-carousel/owl.carousel.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/vendor/lightgallery/dist/css/lightgallery.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/vendor/lightgallery/dist/css/lg-thumbnail.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/vendor/lightgallery/dist/css/lg-zoom.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/vendor/lightgallery/dist/css/lg-video.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/vendor/animate/animate.css')); ?>" rel="stylesheet">

        <!-- Custom Stylesheet -->
        <link rel="stylesheet" href="<?php echo e(asset('assets/css/style.css')); ?>">
        <link rel="stylesheet" href="<?php echo e(asset('assets/vendor/rangeslider/rangeslider.css')); ?>">

        <!-- Dynamic Primary Color for Theme -->
    <?php if(Color::supportsColorCustomization($settings->theme) && $settings->primary_color): ?>
    <style>
        :root {
            --primary: <?php echo e($settings->primary_color->hex()); ?>;
            --primaryhover: <?php echo e($settings->primary_color->hex()); ?>dd;
        }

        .bg-primary { background-color: var(--primary) !important; }
        .text-primary { color: var(--primary) !important; }
        .border-primary { border-color: var(--primary) !important; }
        .hover\:bg-primary:hover { background-color: var(--primary) !important; }
        .hover\:text-primary:hover { color: var(--primary) !important; }
        .hover\:border-primary:hover { border-color: var(--primary) !important; }

        .bg-primaryhover { background-color: var(--primaryhover) !important; }
        .hover\:bg-primaryhover:hover { background-color: var(--primaryhover) !important; }




    </style>
    <?php endif; ?>
    <!-- Google Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin="">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&family=Poppins:ital,wght@0,100;0,200;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap" rel="stylesheet">
</head>
<body id="bg" class="selection:bg-primary selection:text-white bg-fixed bg-cover font-Roboto bg-white skin-1 <?php echo e(request()->routeIs('home') ? 'home' : ''); ?>">

    <div id="loading-area" class="fixed w-full h-full left-0 top-0 z-[999999999] bg-center bg-no-repeat bg-[length:80px] bg-[#f4f2ff] bg-[url('<?php echo e(asset('assets/images/loading-01.svg')); ?>')] loading-01"></div>

<div class="page-wraper">
    <!-- Header -->
    <header class="site-header header mo-left header-transparent text-black absolute w-full">
        <!-- Main Header -->
        <div class="sticky-header main-bar-wraper navbar-expand-lg">
            <div class="main-bar clearfix ">
                <div class="container clearfix">

                    <!-- Website Logo -->
                    <div class="logo-header logo-dark">
                        <a href="<?php echo e(route('home')); ?>" class="flex items-center space-x-3">
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 71 75" width="45" height="47" fill="currentColor" class="text-primary">
                                <circle cx="17.12" cy="22.88" r="1.6"/>
                                <circle cx="17.5" cy="36" r="1.95"/>
                                <circle cx="18.1" cy="48.57" r="2.59"/>
                                <circle cx="28.36" cy="18.76" r="3.24"/>
                                <circle cx="28.36" cy="53.24" r="3.24"/>
                                <circle cx="28.4" cy="30.6" r="2.19"/>
                                <circle cx="28.5" cy="42" r="2.26"/>
                                <circle cx="39" cy="13.27" r="4.03"/>
                                <circle cx="39" cy="36" r="2.59"/>
                                <circle cx="39" cy="58.73" r="4.03"/>
                                <circle cx="39.44" cy="24.69" r="3.19"/>
                                <circle cx="39.44" cy="47.31" r="3.19"/>
                                <circle cx="48.62" cy="41.93" r="3.04"/>
                                <circle cx="48.69" cy="30.55" r="3.04"/>
                                <circle cx="48.98" cy="19.08" r="3.91"/>
                                <circle cx="48.98" cy="52.92" r="3.91"/>
                                <circle cx="58.41" cy="36" r="4.15"/>
                                <circle cx="58.5" cy="24.73" r="4.07"/>
                                <circle cx="58.5" cy="47.27" r="4.07"/>
                            </svg>
                            <span class="text-xl font-bold text-gray-800 dark:text-white"><?php echo e($settings->website_name ?? 'DigiMarket'); ?></span>
                        </a>
                    </div>

                    <!-- Nav Toggle Button -->
                    <button class="navbar-toggler navicon justify-end" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNavDropdown" aria-controls="navbarNavDropdown" aria-expanded="false" aria-label="Toggle navigation">
                        <span></span>
                        <span></span>
                        <span></span>
                    </button>

                    <!-- Extra Nav -->
                    <div class="extra-nav max-sm:!hidden">
                        <div class="extra-cell">
                            <?php if($settings->number): ?>
                            <a href="tel:<?php echo e($settings->number); ?>" class="btn py-5 px-[35px] max-xl:py-3 max-xl:px-[25px] text-[15px] max-xl:text-sm inline-block font-medium leading-[1.2] uppercase bg-primary hover:bg-primaryhover text-white rounded duration-700 group">
                                <i class="fa fa-phone ltr:mr-2.5 rtl:ml-2.5 duration-1000 group-hover:animate-toLeftFromRight"></i>
                                <?php echo e($settings->number); ?>

                            </a>
                            <?php else: ?>
                            <a href="<?php echo e(route('contact')); ?>" class="btn py-5 px-[35px] max-xl:py-3 max-xl:px-[25px] text-[15px] max-xl:text-sm inline-block font-medium leading-[1.2] uppercase bg-primary hover:bg-primaryhover text-white rounded duration-700 group">
                                <i class="fa fa-phone ltr:mr-2.5 rtl:ml-2.5 duration-1000 group-hover:animate-toLeftFromRight"></i>
                                Call Us
                            </a>
                            <?php endif; ?>
                        </div>
                    </div>

                    <div class="header-nav navbar-collapse justify-end" id="navbarNavDropdown">
                        <div class="logo-header logo-dark">
                            <a href="<?php echo e(route('home')); ?>" class="flex items-center space-x-3">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 71 75" width="45" height="47" fill="currentColor" class="text-primary">
                                    <circle cx="17.12" cy="22.88" r="1.6"/>
                                    <circle cx="17.5" cy="36" r="1.95"/>
                                    <circle cx="18.1" cy="48.57" r="2.59"/>
                                    <circle cx="28.36" cy="18.76" r="3.24"/>
                                    <circle cx="28.36" cy="53.24" r="3.24"/>
                                    <circle cx="28.4" cy="30.6" r="2.19"/>
                                    <circle cx="28.5" cy="42" r="2.26"/>
                                    <circle cx="39" cy="13.27" r="4.03"/>
                                    <circle cx="39" cy="36" r="2.59"/>
                                    <circle cx="39" cy="58.73" r="4.03"/>
                                    <circle cx="39.44" cy="24.69" r="3.19"/>
                                    <circle cx="39.44" cy="47.31" r="3.19"/>
                                    <circle cx="48.62" cy="41.93" r="3.04"/>
                                    <circle cx="48.69" cy="30.55" r="3.04"/>
                                    <circle cx="48.98" cy="19.08" r="3.91"/>
                                    <circle cx="48.98" cy="52.92" r="3.91"/>
                                    <circle cx="58.41" cy="36" r="4.15"/>
                                    <circle cx="58.5" cy="24.73" r="4.07"/>
                                    <circle cx="58.5" cy="47.27" r="4.07"/>
                                </svg>
                                <span class="text-xl font-bold text-gray-800 dark:text-white"><?php echo e($settings->website_name ?? 'DigiMarket'); ?></span>
                            </a>
                        </div>
                        <ul class="nav navbar-nav navbar">
                            <li><a href="<?php echo e(route('home')); ?>"><span>Home</span></a></li>
                            <li><a href="<?php echo e(route('about')); ?>"><span>About</span></a></li>
                            <li><a href="<?php echo e(route('pricing')); ?>"><span>Pricing</span></a></li>
                            <li><a href="<?php echo e(route('contact')); ?>"><span>Contact Us</span></a></li>

                        </ul>

                    </div>
                </div>
            </div>
        </div>
        <!-- Main Header End -->
    </header>
    <!-- Header End -->

    <div class="page-content bg-white">
        <?php echo $__env->yieldContent('content'); ?>
    </div>

    <!-- Footer -->
    <footer class="site-footer style-1 bg-[url('<?php echo e(asset('assets/images/background/bg10.png')); ?>')] bg-no-repeat bg-center bg-cover bg-primary text-[15px] text-white" id="footer">
        <div class="pt-[70px] pb-7.5 max-md:pt-[50px] max-md:pb-5 bg-transparent">
            <div class="container">
                <div class="mb-7.5 pb-2.5 border-b border-[#ffffff4d] wow fadeIn" data-wow-duration="2s" data-wow-delay="0.8s">
                    <div class="row items-center">
                        <div class="xl:w-5/12 md:w-1/3 w-full">
                                                    <div class="mb-2.5">
                            <a href="<?php echo e(route('home')); ?>" class="flex items-center space-x-3">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 71 75" width="45" height="47" fill="currentColor" class="text-white">
                                    <circle cx="17.12" cy="22.88" r="1.6"/>
                                    <circle cx="17.5" cy="36" r="1.95"/>
                                    <circle cx="18.1" cy="48.57" r="2.59"/>
                                    <circle cx="28.36" cy="18.76" r="3.24"/>
                                    <circle cx="28.36" cy="53.24" r="3.24"/>
                                    <circle cx="28.4" cy="30.6" r="2.19"/>
                                    <circle cx="28.5" cy="42" r="2.26"/>
                                    <circle cx="39" cy="13.27" r="4.03"/>
                                    <circle cx="39" cy="36" r="2.59"/>
                                    <circle cx="39" cy="58.73" r="4.03"/>
                                    <circle cx="39.44" cy="24.69" r="3.19"/>
                                    <circle cx="39.44" cy="47.31" r="3.19"/>
                                    <circle cx="48.62" cy="41.93" r="3.04"/>
                                    <circle cx="48.69" cy="30.55" r="3.04"/>
                                    <circle cx="48.98" cy="19.08" r="3.91"/>
                                    <circle cx="48.98" cy="52.92" r="3.91"/>
                                    <circle cx="58.41" cy="36" r="4.15"/>
                                    <circle cx="58.5" cy="24.73" r="4.07"/>
                                    <circle cx="58.5" cy="47.27" r="4.07"/>
                                </svg>
                                <span class="text-xl font-bold text-white"><?php echo e($settings->website_name ?? 'DigiMarket'); ?></span>
                            </a>
                        </div>
                        </div>
                        <div class="xl:w-1/4 md:w-1/3 sm:w-1/2 w-full">
                            <div class="flex items-center relative mb-2.5">
                                <div class="ltr:float-left rtl:float-right ltr:mr-2.5 rtl:ml-2.5 inline-block text-center w-20 min-w-20">
                                    <a href="javascript:void(0);" class="text-white">
                                        <i class="flaticon-email text-[50px]"></i>
                                    </a>
                                </div>
                                <div class="overflow-hidden">
                                    <?php if($settings->number): ?>
                                    <p class="text-base max-xl:text-[15px] text-[#ffffff99] mb-0"><strong class="text-white font-extrabold md:text-lg text-base"><?php echo e($settings->number); ?></strong><br><?php echo e($settings->email ?? 'info@example.com'); ?></p>
                                    <?php else: ?>
                                    <p class="text-base max-xl:text-[15px] text-[#ffffff99] mb-0"><strong class="text-white font-extrabold md:text-lg text-base">+91 987-654-3210</strong><br><?php echo e($settings->email ?? 'info@example.com'); ?></p>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        <div class="md:w-1/3 sm:w-1/2 w-full">
                            <div class="flex items-center relative mb-2.5">
                                <div class="ltr:float-left rtl:float-right ltr:mr-2.5 rtl:ml-2.5 inline-block text-center w-20 min-w-20">
                                    <a href="javascript:void(0);" class="text-white">
                                        <i class="flaticon-location text-[50px]"></i>
                                    </a>
                                </div>
                                <div class="overflow-hidden">
                                    <p class="text-base max-xl:text-[15px] text-[#ffffff99] mb-0"><?php echo e($settings->address ?? '1247/Plot No. 39, 15th Phase, Colony, Kkatpally, Hyderabad'); ?></p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="xl:w-1/4 lg:w-1/3 sm:w-1/2 w-full wow fadeIn" data-wow-duration="2s" data-wow-delay="0.2s">
                        <div class="mb-7.5 widget_about">
                            <h5 class="footer-title text-2xl font-bold pb-2.5 mb-7.5 relative !text-white leading-[1.2]">ABOUT US</h5>
                            <p class="mb-5 leading-6 opacity-60"><?php echo e($settings->website_name ?? 'DigiMarket'); ?> is your premier destination for <?php echo e($settings->website_content_name ?? 'digital products'); ?>. We connect talented creators with customers worldwide.</p>
                        </div>
                    </div>
                    <div class="xl:w-1/4 lg:w-1/6 sm:w-1/2 w-full wow fadeIn" data-wow-duration="2s" data-wow-delay="0.4s">
                        <div class="mb-7.5 widget_services">
                            <h5 class="footer-title text-2xl font-bold pb-2.5 mb-7.5 relative !text-white leading-[1.2]">OUR LINKS</h5>
                            <ul class="mt-[-5px] text-[#ffffff99]">
                                <li class="py-2 px-[15px] leading-5 relative"><a href="<?php echo e(route('home')); ?>" class="relative duration-500 hover:text-white">Home</a></li>
                                <li class="py-2 px-[15px] leading-5 relative"><a href="<?php echo e(route('about')); ?>" class="relative duration-500 hover:text-white">About Us</a></li>
                                <li class="py-2 px-[15px] leading-5 relative"><a href="<?php echo e(route('pricing')); ?>" class="relative duration-500 hover:text-white">Pricing</a></li>
                                <li class="py-2 px-[15px] leading-5 relative"><a href="<?php echo e(route('contact')); ?>" class="relative duration-500 hover:text-white">Contact</a></li>
                            </ul>
                        </div>
                    </div>
                    <div class="lg:w-1/4 sm:w-1/2 w-full wow fadeIn" data-wow-duration="2s" data-wow-delay="0.6s">
                        <div class="mb-7.5 widget_services">
                            <h5 class="footer-title text-2xl font-bold pb-2.5 mb-7.5 relative !text-white leading-[1.2]">OUR SERVICES</h5>
                            <ul class="mt-[-5px] text-[#ffffff99]">
                                <?php $__currentLoopData = $services->take(5); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li class="py-2 px-[15px] leading-5 relative">
                                        <a href="<?php echo e(route('pricing')); ?>" class="relative duration-500 hover:text-white"><?php echo e($service->name); ?></a>
                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    </div>
                    <div class="lg:w-1/4 sm:w-1/2 w-full wow fadeIn" data-wow-duration="2s" data-wow-delay="0.8s">
                        <div class="mb-7.5 widget_services">
                           <h5 class="footer-title text-2xl font-bold pb-2.5 mb-7.5 relative !text-white leading-[1.2]">OTHER LINKS</h5>
                           <ul class="mt-[-5px] text-[#ffffff99]">
                                <li class="py-2 px-[15px] leading-5 relative"><a href="<?php echo e(route('privacy-policy')); ?>" class="relative duration-500 hover:text-white">Privacy Policy</a></li>
                                <li class="py-2 px-[15px] leading-5 relative"><a href="<?php echo e(route('terms-conditions')); ?>" class="relative duration-500 hover:text-white">Terms & Conditions</a></li>
                                <li class="py-2 px-[15px] leading-5 relative"><a href="<?php echo e(route('refund-policy')); ?>" class="relative duration-500 hover:text-white">Refund Policy</a></li>
                            </ul>

                            <!-- Small Payment Methods Section -->
                            <div class="mt-4">
                                <h5 class="footer-title text-2xl font-bold pb-2.5 mb-7.5 relative !text-white leading-[1.2]">We Accept</h5>
                                <img src="<?php echo e(asset('assets/images/pay_methods.png')); ?>" alt="Payment Methods" class="max-w-[120px] h-auto">
                            </div>
                        </div>
                    </div>
                                </div>
            </div>
        </div>
        <!-- footer bottom part -->
        <div class="bg-primarydark py-[15px] wow fadeIn" data-wow-duration="2s" data-wow-delay="0.2s">
            <div class="container">
                <div class="row">
                    <div class="w-full text-center">
                        <span class="text-[#ffffff80]">Copyright © <?php echo e(date('Y')); ?> <a href="<?php echo e(route('home')); ?>" class="text-white font-normal"><?php echo e($settings->website_content_name ?? 'DigiMarket'); ?></a>. All rights reserved.</span>
                    </div>
                </div>
            </div>
        </div>
    </footer>
    <!-- Footer End -->
    <button class="shadow-[-4px_4px_24px_-10px_var(--primary)] bg-primary rounded bottom-[15px] text-white size-[50px] leading-[50px] max-sm:size-10 max-sm:leading-10 max-sm:text-sm fixed ltr:right-[15px] rtl:left-[15px] text-center z-[999] duration-700 scroltop icon-up" type="button"><i class="fa fa-arrow-up"></i></button>
</div>

<!-- JAVASCRIPT FILES ========================================= -->
<script src="<?php echo e(asset('assets/js/jquery.min.js')); ?>"></script><!-- JQUERY.MIN JS -->
<script src="<?php echo e(asset('assets/vendor/magnific-popup/magnific-popup.js')); ?>"></script><!-- MAGNIFIC POPUP JS -->
<script src="<?php echo e(asset('assets/vendor/lightgallery/dist/lightgallery.min.js')); ?>"></script><!-- LIGHTGALLERY JS -->
<script src="<?php echo e(asset('assets/vendor/lightgallery/dist/plugins/thumbnail/lg-thumbnail.min.js')); ?>"></script><!-- LIGHTGALLERY THUMBNAIL JS -->
<script src="<?php echo e(asset('assets/vendor/lightgallery/dist/plugins/video/lg-video.min.js')); ?>"></script><!-- LIGHTGALLERY VIDEO JS -->
<script src="<?php echo e(asset('assets/vendor/lightgallery/dist/plugins/zoom/lg-zoom.min.js')); ?>"></script><!-- LIGHTGALLERY ZOOM JS -->
<script src="<?php echo e(asset('assets/vendor/owl-carousel/owl.carousel.js')); ?>"></script><!-- OWL CAROUSEL JS -->
<script src="<?php echo e(asset('assets/vendor/swiper/swiper-bundle.min.js')); ?>"></script><!-- SWIPER JS -->
<script src="<?php echo e(asset('assets/vendor/counter/counterup.min.js')); ?>"></script><!-- COUNTERUP JS -->
<script src="<?php echo e(asset('assets/vendor/counter/waypoints-min.js')); ?>"></script><!-- WAYPOINTS JS -->
<script src="<?php echo e(asset('assets/vendor/wow/wow.js')); ?>"></script><!-- WOW JS -->
<script src="<?php echo e(asset('assets/vendor/masonry/masonry-4.2.2.js')); ?>"></script><!-- MASONRY JS -->
<script src="<?php echo e(asset('assets/vendor/masonry/isotope.pkgd.min.js')); ?>"></script><!-- MASONRY JS -->
<script src="<?php echo e(asset('assets/vendor/rangeslider/rangeslider.js')); ?>"></script><!-- RANGESLIDER JS -->
<script src="<?php echo e(asset('assets/vendor/niceselect/js/jquery.nice-select.js')); ?>"></script><!-- NICESELECT JS -->
<script src="<?php echo e(asset('assets/vendor/imagesloaded/imagesloaded.js')); ?>"></script><!-- IMAGESLOADED JS -->
<script src="<?php echo e(asset('assets/vendor/countdown/jquery.countdown.js')); ?>"></script><!-- COUNTDOWN JS -->
<script src="<?php echo e(asset('assets/js/dz.carousel.js')); ?>"></script><!-- OWL CAROUSEL JS -->
<script src="<?php echo e(asset('assets/js/dz.ajax.js')); ?>"></script><!-- AJAX JS -->
<script src="<?php echo e(asset('assets/js/custom.js')); ?>"></script><!-- CUSTOM JS -->

<!-- Contact Form Handler -->
<script>
document.addEventListener('DOMContentLoaded', function() {
        // Typewriter effect for home page
    const typewriterText = document.getElementById('typewriter-text');
    if (typewriterText) {
        const words = ['Success', 'Business'];
        let wordIndex = 0;
        let charIndex = 0;
        let isDeleting = false;
        let typingSpeed = 80; // Faster typing speed

        function typeWriter() {
            const currentWord = words[wordIndex];

            if (isDeleting) {
                // Deleting effect
                typewriterText.textContent = currentWord.substring(0, charIndex - 1);
                charIndex--;
                typingSpeed = 50; // Faster deleting speed
            } else {
                // Typing effect
                typewriterText.textContent = currentWord.substring(0, charIndex + 1);
                charIndex++;
                typingSpeed = 80; // Faster typing speed
            }

            // Change direction when word is complete
            if (!isDeleting && charIndex === currentWord.length) {
                // Pause at end of word
                typingSpeed = 1000; // Shorter pause
                isDeleting = true;
            } else if (isDeleting && charIndex === 0) {
                // Move to next word
                isDeleting = false;
                wordIndex = (wordIndex + 1) % words.length;
                typingSpeed = 300; // Shorter pause before starting next word
            }

            setTimeout(typeWriter, typingSpeed);
        }

        // Start the typewriter effect after a delay
        setTimeout(typeWriter, 1500); // Shorter initial delay
    }

    // Handle all contact forms with class 'dzForm'
    const contactForms = document.querySelectorAll('.dzForm');

    // Handle newsletter subscription forms
    const newsletterForms = document.querySelectorAll('.dzSubscribe');

    newsletterForms.forEach(function(form) {
        form.addEventListener('submit', function(e) {
            e.preventDefault();

            // Get form data
            const formData = new FormData(form);
            const submitButton = form.querySelector('button[type="submit"]');
            const emailInput = form.querySelector('input[name="dzEmail"]');
            const originalText = submitButton.innerHTML;

            // Validate email
            if (!emailInput.value.trim() || !isValidEmail(emailInput.value)) {
                showErrorToast('Please enter a valid email address.');
                emailInput.focus();
                return;
            }

            // Disable submit button and show loading state
            submitButton.disabled = true;
            submitButton.innerHTML = '<i class="fa fa-spinner fa-spin"></i> Subscribing...';

            // Simulate form submission (replace with actual AJAX call if needed)
            setTimeout(function() {
                // Clear form
                emailInput.value = '';

                // Reset submit button
                submitButton.disabled = false;
                submitButton.innerHTML = originalText;

                // Show success toast
                showSuccessToast('Thank you! You have been successfully subscribed to our newsletter.');

            }, 1500); // Simulate 1.5 second delay
        });
    });

    // Email validation function
    function isValidEmail(email) {
        const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
        return emailRegex.test(email);
    }

        contactForms.forEach(function(form) {
        // Handle submit button click (since it's an anchor tag, not a submit button)
        const submitButton = form.querySelector('a[href="javascript:void(0);"]');
        if (submitButton) {
            submitButton.addEventListener('click', function(e) {
                e.preventDefault();

                // Validate form
                const requiredFields = form.querySelectorAll('input[required], textarea[required]');
                let isValid = true;

                requiredFields.forEach(function(field) {
                    if (!field.value.trim()) {
                        isValid = false;
                        field.style.borderColor = '#ef4444';
                        field.focus();
                    } else {
                        field.style.borderColor = '#cccccc';
                    }
                });

                if (!isValid) {
                    showErrorToast('Please fill in all required fields.');
                    return;
                }

                // Get form data
                const formData = new FormData(form);
                const originalText = submitButton.innerHTML;

                // Disable submit button and show loading state
                submitButton.style.pointerEvents = 'none';
                submitButton.innerHTML = '<i class="fa fa-spinner fa-spin ltr:mr-2.5 rtl:ml-2.5"></i>Sending...';

                // Simulate form submission (replace with actual AJAX call if needed)
                setTimeout(function() {
                    // Clear all form fields
                    const inputs = form.querySelectorAll('input[type="text"], input[type="email"], textarea, select');
                    inputs.forEach(function(input) {
                        if (input.tagName === 'SELECT') {
                            input.selectedIndex = 0;
                        } else {
                            input.value = '';
                        }
                        // Reset border color
                        input.style.borderColor = '#cccccc';
                    });

                    // Reset submit button
                    submitButton.style.pointerEvents = 'auto';
                    submitButton.innerHTML = originalText;

                    // Show success toast
                    showSuccessToast('Thank you! Your message has been sent successfully. We will get back to you soon.');

                }, 1500); // Simulate 1.5 second delay
            });
        }
    });

        // Function to show success toast
    function showSuccessToast(message) {
        showToast(message, 'success');
    }

    // Function to show error toast
    function showErrorToast(message) {
        showToast(message, 'error');
    }

    // Generic toast function
    function showToast(message, type = 'success') {
        // Create toast container if it doesn't exist
        let toastContainer = document.getElementById('toast-container');
        if (!toastContainer) {
            toastContainer = document.createElement('div');
            toastContainer.id = 'toast-container';
            toastContainer.style.cssText = `
                position: fixed;
                top: 20px;
                right: 20px;
                z-index: 999999;
                max-width: 400px;
            `;
            document.body.appendChild(toastContainer);
        }

        // Create toast element
        const toast = document.createElement('div');
        const isError = type === 'error';

        toast.style.cssText = `
            background: ${isError ? 'linear-gradient(135deg, #ef4444 0%, #dc2626 100%)' : 'linear-gradient(135deg, #667eea 0%, #764ba2 100%)'};
            color: white;
            padding: 16px 20px;
            border-radius: 8px;
            margin-bottom: 10px;
            box-shadow: 0 4px 12px rgba(0,0,0,0.15);
            transform: translateX(100%);
            transition: transform 0.3s ease;
            display: flex;
            align-items: center;
            gap: 12px;
            font-family: 'Poppins', sans-serif;
            font-size: 14px;
            line-height: 1.4;
        `;

        // Add icon and message
        const icon = isError ? 'fa-exclamation-circle' : 'fa-check-circle';
        const iconColor = isError ? '#fecaca' : '#4ade80';

        toast.innerHTML = `
            <i class="fa ${icon}" style="font-size: 18px; color: ${iconColor};"></i>
            <span>${message}</span>
        `;

        // Add to container
        toastContainer.appendChild(toast);

        // Animate in
        setTimeout(() => {
            toast.style.transform = 'translateX(0)';
        }, 100);

        // Auto remove after 5 seconds
        setTimeout(() => {
            toast.style.transform = 'translateX(100%)';
            setTimeout(() => {
                if (toast.parentNode) {
                    toast.parentNode.removeChild(toast);
                }
            }, 300);
        }, 5000);

        // Allow manual close on click
        toast.addEventListener('click', function() {
            toast.style.transform = 'translateX(100%)';
            setTimeout(() => {
                if (toast.parentNode) {
                    toast.parentNode.removeChild(toast);
                }
            }, 300);
        });
    }
});
</script>

</body>
</html>
<?php /**PATH E:\makeapp\resources\views/themes/digimarket/layout.blade.php ENDPATH**/ ?>