@extends('themes.digimarket2.layout')

@section('content')
    	<!-- Banner  -->
		
		<div class="dlab-bnr-inr style-1 bg-primary w-full h-[480px] max-sm:h-[300px] bg-center bg-[length:cover,_200%] relative overflow-hidden" style="background-image: url(assets/images/banner/bnr2.png), var(--gradient-sec);">
			<div class="container table h-full relative z-1">
				<div class="h-full table-cell align-middle text-white relative text-center dlab-bnr-inr-entry">
					<h1 class="!text-white mb-5 max-sm:mb-[5px] text-[60px] max-lg:text-[40px] max-sm:!text-[32px] leading-[75px] max-lg:leading-[1.2]">Services</h1>
					<!-- Breadcrumb Row -->
					<nav class="breadcrumb-row max-md:inline-block">
						<ul class="inline-flex flex-wrap gradient bg-[length:200%] duration-1000 py-[5px] px-5 rounded-[30px]">
							<li class="ltr:mr-[3px] rtl:ml-[3px] flex items-center text-lg max-lg:text-[15px] font-poppins"><a href="index.html">Home</a></li>
							<li class="ltr:mr-[3px] rtl:ml-[3px] flex items-center text-lg max-lg:text-[15px] font-poppins ltr:pl-2 rtl:pr-2 before:content-['\f105'] before:font-['Line_Awesome_Free'] before:font-bold ltr:before:pr-2 rtl:before:pl-2 active">Services</li>
						</ul>
					</nav>
					<!-- Breadcrumb Row End -->
				</div>
			</div>
		</div>
		<!-- Banner End -->
    <!-- Counter -->
    <section
        class="lg:pt-[115px] lg:pb-[85px] sm:pt-[70px] sm:pb-10 pt-[50px] pb-5 bg-secondary bg-[url('assets/images/background/bg22.png')] bg-cover">
        <div class="container">
            <div class="mb-10 max-xl:mb-7.5 style-4 text-center wow fadeInUp" data-wow-duration="2s"
                data-wow-delay="0.1s">
                <h2 class="text-[50px] max-lg:text-[32px] font-bold !text-primary">How We Can Help Your <br> Business Goal
                </h2>
            </div>
            <div class="row justify-center">
                <div class="xl:w-1/4 lg:w-5/12 sm:w-1/2 w-5/6">
                    <div class="p-5 bg-white z-1 flex relative duration-1000 rounded-[10px] shadow-[0_0px_60px_0px_rgba(0,0,0,0.1)] icon-bx-wraper style-11 box-hover mb-7.5 wow fadeInRight"
                        data-wow-duration="2s" data-wow-delay="0.3s">
                        <div
                            class="icon-bx-sm inline-block text-center w-20 h-20 leading-[80px] ltr:mr-5 rtl:ml-5 ltr:float-left rtl:float-right">
                            <a href="javascript:void(0);" class="icon-cell">
                                <img src="assets/images/icon/icon12.svg" alt="" class="w-[85%] h-full">
                            </a>
                        </div>
                        <div class="icon-content">
                            <h4 class="text-[50px] font-bold mb-0"><span class="counter">150</span>+</h4>
                            <p class="mb-0 text-primary leading-5 font-medium text-[15px]">Satisfied Clients</p>
                        </div>
                    </div>
                </div>
                <div class="xl:w-1/4 lg:w-5/12 sm:w-1/2 w-5/6">
                    <div class="p-5 bg-white z-1 flex relative duration-1000 rounded-[10px] shadow-[0_0px_60px_0px_rgba(0,0,0,0.1)] icon-bx-wraper style-11 box-hover mb-7.5 wow fadeInRight"
                        data-wow-duration="2s" data-wow-delay="0.4s">
                        <div
                            class="icon-bx-sm inline-block text-center w-20 h-20 leading-[80px] ltr:mr-5 rtl:ml-5 ltr:float-left rtl:float-right">
                            <a href="javascript:void(0);" class="icon-cell">
                                <img src="assets/images/icon/icon9.svg" alt="" class="w-[85%] h-full">
                            </a>
                        </div>
                        <div class="icon-content">
                            <h4 class="text-[50px] font-bold mb-0"><span class="counter">500</span>+</h4>
                            <p class="mb-0 text-primary leading-5 font-medium text-[15px]">Projects</p>
                        </div>
                    </div>
                </div>
                <div class="xl:w-1/4 lg:w-5/12 sm:w-1/2 w-5/6">
                    <div class="p-5 bg-white z-1 flex relative duration-1000 rounded-[10px] shadow-[0_0px_60px_0px_rgba(0,0,0,0.1)] icon-bx-wraper style-11 box-hover mb-7.5 wow fadeInRight"
                        data-wow-duration="2s" data-wow-delay="0.5s">
                        <div
                            class="icon-bx-sm inline-block text-center w-20 h-20 leading-[80px] ltr:mr-5 rtl:ml-5 ltr:float-left rtl:float-right">
                            <a href="javascript:void(0);" class="icon-cell">
                                <img src="assets/images/icon/icon10.svg" alt="" class="w-[85%] h-full">
                            </a>
                        </div>
                        <div class="icon-content">
                            <h4 class="text-[50px] font-bold mb-0"><span class="counter">300</span>%</h4>
                            <p class="mb-0 text-primary leading-5 font-medium text-[15px]">ROI Increase</p>
                        </div>
                    </div>
                </div>
                <div class="xl:w-1/4 lg:w-5/12 sm:w-1/2 w-5/6">
                    <div class="p-5 bg-white z-1 flex relative duration-1000 rounded-[10px] shadow-[0_0px_60px_0px_rgba(0,0,0,0.1)] icon-bx-wraper style-11 box-hover mb-7.5 wow fadeInRight"
                        data-wow-duration="2s" data-wow-delay="0.6s">
                        <div
                            class="icon-bx-sm inline-block text-center w-20 h-20 leading-[80px] ltr:mr-5 rtl:ml-5 ltr:float-left rtl:float-right">
                            <a href="javascript:void(0);" class="icon-cell">
                                <img src="assets/images/icon/icon11.svg" alt="" class="w-[85%] h-full">
                            </a>
                        </div>
                        <div class="icon-content">
                            <h4 class="text-[50px] font-bold mb-0"><span class="counter">8</span>+</h4>
                            <p class="mb-0 text-primary leading-5 font-medium text-[15px]">Years Experience</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Services -->
    <section class="lg:pt-[115px] lg:pb-[85px] sm:pt-[70px] sm:pb-10 pt-[50px] pb-5 bg-[length:cover,_200%] bg-no-repeat"
        style="background-image: url(assets/images/background/bg12.png), var(--gradient-sec);">
        <div class="container">
            <div class="mb-10 max-xl:mb-7.5 text-center">
                <h2 class="title !text-white">Our Digital Marketing Services</h2>
            </div>
            <div class="row -mx-4">
                @foreach ($services as $index => $service)
                    <div class="lg:w-1/3 md:w-1/2 wow fadeInUp px-4" style="margin-bottom: 2rem;" data-wow-duration="2s"
                        data-wow-delay="{{ ($index + 1) * 0.2 }}s">
                        <div
                            class="relative rounded-2xl p-[35px] duration-1000 icon-bx-wraper style-5 box-hover text-center mb-7.5 bg-white shadow-lg hover:shadow-xl transition-all h-full flex flex-col {{ $index == 1 ? 'active' : '' }}">
                            <div
                                class="icon-bx relative overflow-hidden z-1 bg-[#e7e5ee] size-[165px] m-auto leading-[160px]">
                                @php
                                    $icons = [
                                        'flaticon-line-graph',
                                        'flaticon-idea',
                                        'flaticon-rocket',
                                        'flaticon-smile',
                                        'flaticon-startup',
                                        'flaticon-confetti',
                                    ];
                                    $icon = $icons[$index % count($icons)];
                                @endphp
                                <span class="icon-cell text-[60px] text-[#37226d] duartion-1000"><i
                                        class="{{ $icon }}"></i></span>
                            </div>
                            <div class="icon-content overflow-hidden flex-1 flex flex-col">
                                <h4 class="dlab-title mb-[15px]">{{ $service->name }}</h4>
                                <p class="mb-5 flex-1">{{ Str::limit($service->description, 120) }}</p>
                                @if ($service->price)
                                    <div class="service-price mb-4">
                                        <span
                                            class="price-amount text-primary font-bold">${{ number_format($service->price, 2) }}</span>
                                        <span class="price-label text-sm text-gray-600">Starting Price</span>
                                    </div>
                                @endif
                                <a href="{{ route('contact') }}"
                                    class="btn inline-block text-center px-4 rounded-full leading-[45px] text-xl relative overflow-hidden z-1 border border-primary text-primary mt-auto">Get
                                    Quote <i class="fa fa-angle-right duration-1000 hover:animate-toLeftFromRight"></i></a>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </section>


@endsection
