@extends('themes.digimarket2.layout')

@section('content')
    	<!-- Banner  -->
		
		<div class="dlab-bnr-inr style-1 bg-primary w-full h-[480px] max-sm:h-[300px] bg-center bg-[length:cover,_200%] relative overflow-hidden" style="background-image: url(assets/images/banner/bnr2.png), var(--gradient-sec);">
			<div class="container table h-full relative z-1">
				<div class="h-full table-cell align-middle text-white relative text-center dlab-bnr-inr-entry">
					<h1 class="!text-white mb-5 max-sm:mb-[5px] text-[60px] max-lg:text-[40px] max-sm:!text-[32px] leading-[75px] max-lg:leading-[1.2]">Contact Us</h1>
					<!-- Breadcrumb Row -->
					<nav class="breadcrumb-row max-md:inline-block">
						<ul class="inline-flex flex-wrap gradient bg-[length:200%] duration-1000 py-[5px] px-5 rounded-[30px]">
							<li class="ltr:mr-[3px] rtl:ml-[3px] flex items-center text-lg max-lg:text-[15px] font-poppins"><a href="index.html">Home</a></li>
							<li class="ltr:mr-[3px] rtl:ml-[3px] flex items-center text-lg max-lg:text-[15px] font-poppins ltr:pl-2 rtl:pr-2 before:content-['\f105'] before:font-['Line_Awesome_Free'] before:font-bold ltr:before:pr-2 rtl:before:pl-2 active">Contact Us</li>
						</ul>
					</nav>
					<!-- Breadcrumb Row End -->
				</div>
			</div>
		</div>
		<!-- Banner End -->


        <div class="lg:pt-[115px] sm:pt-[70px] pt-[50px]">
			<div class="container">
				<div class="row mt-7.5">
					<div class="lg:w-1/3 md:w-1/2 w-full">
						<div class="relative p-7.5 rounded shadow-[0_0_95px_0px_rgba(0,0,0,0.1)] duration-1000 hover:translate-y-2.5 max-lg:mb-[60px]">
							<div class="mt-[-70px] mb-5 border-box relative top-0px block shadow-wrapper bg-[length:200%] duration-1000 gradient size-20 leading-[80px] text-center rounded-full">
								<a href="javascript:void(0);" class="text-white">
									<i class="las la-phone-volume text-[40px] align-middle"></i>
								</a>
							</div>
							<div class="overflow-hidden">
								<h4 class="mb-2.5">Call Now</h4>
								<p class="text-xl max-xl:text-base leading-[1.4] mb-[5px]">{{ $settings->number ?? '987 654 3210' }}</p>
							</div>
						</div>
					</div>
					<div class="lg:w-1/3 md:w-1/2 w-full">
						<div class="relative p-7.5 rounded shadow-[0_0_95px_0px_rgba(0,0,0,0.1)] duration-1000 hover:translate-y-2.5 max-lg:mb-[60px]">
							<div class="mt-[-70px] mb-5 border-box relative top-0px block shadow-wrapper bg-[length:200%] duration-1000 gradient size-20 leading-[80px] text-center rounded-full">
								<a href="javascript:void(0);" class="text-white">
									<i class="las la-map-marker text-[40px] align-middle"></i>
								</a>
							</div>
							<div class="overflow-hidden">
								<h4 class="mb-2.5">Location</h4>
								<p class="text-xl max-xl:text-base leading-[1.4] mb-[5px]">{{ $settings->address ?? '1247/Plot No. 39, 15th Phase, Colony, Kukatpally, Hyderabad' }}</p>
							</div>
						</div>
					</div>
					<div class="lg:w-1/3 w-full">
						<div class="relative p-7.5 rounded shadow-[0_0_95px_0px_rgba(0,0,0,0.1)] duration-1000 hover:translate-y-2.5">
							<div class="mt-[-70px] mb-5 border-box relative top-0px block shadow-wrapper bg-[length:200%] duration-1000 gradient size-20 leading-[80px] text-center rounded-full">
								<a href="javascript:void(0);" class="text-white">
									<i class="las la-envelope-open text-[40px] align-middle"></i>
								</a>
							</div>
							<div class="overflow-hidden">
								<h4 class="mb-2.5">Email Now</h4>
								<p class="text-xl max-xl:text-base leading-[1.4] mb-[5px]">{{ $settings->email ?? 'info@digimarket.com' }}</p>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>

        <!-- Contact Form -->
    <section
        class="lg:pt-[115px] lg:pb-[85px] sm:pt-[70px] sm:pb-10 pt-[50px] pb-5 bg-[url('assets/images/background/bg6.jpg')] bg-cover bg-no-repeat">
        <div class="container">
            <div class="row items-center">
                <div class="lg:w-1/2 mb-7.5 wow fadeInLeft lg:block hidden" data-wow-duration="2s" data-wow-delay="0.2s">
                    <div class="dlab-media ltr:ml-[-100px] rtl:mr-[-100px] ltr:max-2xl:mr-0 rtl:max-2xl:ml-0">
                        <img src="assets/images/about/pic4.png" class="animate-move" alt="">
                    </div>
                </div>
                <div class="lg:w-1/2 mb-7.5 wow fadeInRight" data-wow-duration="2s" data-wow-delay="0.4s">
                    <form class="dlab-form dzForm"
                        style="padding: 50px 60px; box-shadow: 0 4px 25px rgba(0,0,0,0.08); background: #fff; border-radius: 10px;"
                        method="POST">
                        <div style="margin-bottom: 30px; text-align: center;">
                            <h3 style="font-size: 42px; line-height: 1.3; font-weight: 700; margin-bottom: 10px;">Get In
                                Touch</h3>
                            <p style="font-size: 15px; color: #555; max-width: 450px; margin: 0 auto;">
                                Ready to grow your business? Let's discuss how
                                {{ $settings->website_content_name ?? 'DigiMarket' }} can help you achieve your digital
                                marketing goals.
                            </p>
                        </div>

                        <div class="dzFormMsg"></div>
                        <input type="hidden" name="dzToDo" value="Contact">
                        <input type="hidden" name="reCaptchaEnable" value="0">

                        <div class="row sp10" style="display: flex; flex-wrap: wrap; gap: 20px;">
                            <!-- First Name -->
                            <div style="flex: 1 1 48%;">
                                <input name="dzFirstName" type="text" required
                                    style="padding: 15px 18px; width: 100%; border-radius: 6px; border: 1px solid #ccc; height: 55px; font-size: 14px;"
                                    placeholder="First Name">
                            </div>
                            <!-- Last Name -->
                            <div style="flex: 1 1 48%;">
                                <input name="dzLastName" type="text" required
                                    style="padding: 15px 18px; width: 100%; border-radius: 6px; border: 1px solid #ccc; height: 55px; font-size: 14px;"
                                    placeholder="Last Name">
                            </div>
                            <!-- Email -->
                            <div style="flex: 1 1 48%;">
                                <input name="dzEmail" type="email" required
                                    style="padding: 15px 18px; width: 100%; border-radius: 6px; border: 1px solid #ccc; height: 55px; font-size: 14px;"
                                    placeholder="Email Address">
                            </div>
                            <!-- Phone -->
                            <div style="flex: 1 1 48%;">
                                <input name="dzPhoneNumber" type="text" required
                                    style="padding: 15px 18px; width: 100%; border-radius: 6px; border: 1px solid #ccc; height: 55px; font-size: 14px;"
                                    placeholder="Phone No.">
                            </div>
                            <!-- Project Title -->
                            <div style="flex: 0 0 100%; width: 100%;">
                                <input name="dzOther[project_title]" type="text" required
                                    style="padding: 15px 18px; width: 100%; border-radius: 6px; border: 1px solid #ccc; height: 55px; font-size: 14px;"
                                    placeholder="Project Title">
                            </div>

                            <!-- Choose Service -->
                            <div style="flex: 0 0 100%; width: 100%;">
                                <select name="dzOther[choose_service]"
                                    style="padding: 15px 18px; width: 100%; border-radius: 6px; border: 1px solid #ccc; height: 55px; font-size: 14px; background: #fff; display: block;">
                                    <option selected="">Choose Service</option>
                                    @foreach ($services as $service)
                                        <option value="{{ $service->id }}">{{ $service->name }}</option>
                                    @endforeach
                                </select>
                            </div>

                            <!-- Message -->
                            <div style="flex: 0 0 100%; width: 100%;">
                                <textarea name="dzMessage" required
                                    style="padding: 15px 18px; width: 100%; border-radius: 6px; border: 1px solid #ccc; height: 140px; font-size: 14px; resize: vertical;"
                                    placeholder="Message"></textarea>
                            </div>
                            <!-- Submit -->
                            <div style="flex: 1 1 100%; text-align: center;">
                                <a href="javascript:void(0);"
                                    class="btn py-5 px-[35px] max-xl:py-3 max-xl:px-[25px] text-[15px] max-xl:text-sm inline-block font-medium leading-[1.2] uppercase bg-primary hover:bg-primaryhover text-white rounded duration-700 group"
                                    style="width: 100%; display: inline-block; text-align: center;">
                                    Submit Now
                                    <i
                                        class="fa fa-angle-right ltr:ml-2.5 rtl:mr-2.5 duration-1000 group-hover:animate-toLeftFromRight"></i>
                                </a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </section>
@endsection
