@extends('themes.coursesell.layout')

@section('content')
<div class="bg-gradient-to-br from-green-50 to-teal-50 py-16">
    <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Hero Section -->
        <div class="text-center mb-16">
            <h1 class="text-5xl font-bold text-gray-900 mb-6">
                Terms and Conditions
            </h1>
            <p class="text-xl text-gray-600 mb-8">
                Last updated: {{ date('F j, Y') }}
            </p>
        </div>

        <!-- Content -->
        <div class="bg-white rounded-xl shadow-lg p-8">
            <div class="prose prose-lg max-w-none">
                <h2 class="text-2xl font-bold text-gray-900 mb-6">1. Acceptance of Terms</h2>
                <p class="text-gray-600 mb-6">
                    By accessing and using {{ $settings->website_name ?? 'CourseSell' }}, you accept and agree to be bound by the terms
                    and provision of this agreement. If you do not agree to abide by the above, please do not use this service.
                </p>

                <h2 class="text-2xl font-bold text-gray-900 mb-6">2. Use License</h2>
                <p class="text-gray-600 mb-4">
                    Permission is granted to temporarily access the educational materials on
                    {{ $settings->website_name ?? 'CourseSell' }} for personal, non-commercial learning purposes only.
                </p>
                <p class="text-gray-600 mb-6">
                    This is the grant of a license, not a transfer of title, and under this license you may not:
                </p>
                <ul class="list-disc pl-6 mb-6 text-gray-600">
                    <li>Modify or copy the course materials</li>
                    <li>Use the materials for any commercial purpose or for any public display</li>
                    <li>Attempt to reverse engineer any software contained on the website</li>
                    <li>Remove any copyright or other proprietary notations from the materials</li>
                    <li>Share your account credentials with others</li>
                </ul>

                <h2 class="text-2xl font-bold text-gray-900 mb-6">3. {{ $settings->website_content_name ?? 'Course' }} Terms</h2>
                <p class="text-gray-600 mb-4">
                    When enrolling in {{ $settings->website_content_name ?? 'courses' }} from our platform:
                </p>
                <ul class="list-disc pl-6 mb-6 text-gray-600">
                    <li>All enrollments are final unless otherwise specified</li>
                    <li>You agree to use the courses for personal learning only</li>
                    <li>You may not redistribute or share course content</li>
                    <li>We reserve the right to modify or discontinue courses at any time</li>
                    <li>Course access is limited to the duration specified in your plan</li>
                </ul>

                <h2 class="text-2xl font-bold text-gray-900 mb-6">4. User Accounts</h2>
                <p class="text-gray-600 mb-4">
                    To access certain features of {{ $settings->website_name ?? 'CourseSell' }}, you must create an account. You are responsible for:
                </p>
                <ul class="list-disc pl-6 mb-6 text-gray-600">
                    <li>Maintaining the confidentiality of your account information</li>
                    <li>All activities that occur under your account</li>
                    <li>Notifying us immediately of any unauthorized use</li>
                    <li>Ensuring your account information is accurate and up-to-date</li>
                </ul>

                <h2 class="text-2xl font-bold text-gray-900 mb-6">5. Payment Terms</h2>
                <p class="text-gray-600 mb-6">
                    All payments must be made in full at the time of enrollment. We accept various payment methods as indicated
                    on our website. Prices are subject to change without notice.
                </p>

                <h2 class="text-2xl font-bold text-gray-900 mb-6">6. Intellectual Property</h2>
                <p class="text-gray-600 mb-6">
                    The content on {{ $settings->website_name ?? 'CourseSell' }}, including but not limited to text, graphics,
                    images, logos, and course materials, is the property of {{ $settings->website_name ?? 'CourseSell' }} and is protected
                    by copyright and other intellectual property laws.
                </p>

                <h2 class="text-2xl font-bold text-gray-900 mb-6">7. Disclaimer</h2>
                <p class="text-gray-600 mb-6">
                    The materials on {{ $settings->website_name ?? 'CourseSell' }} are provided on an 'as is' basis.
                    {{ $settings->website_name ?? 'CourseSell' }} makes no warranties, expressed or implied, and hereby disclaims
                    and negates all other warranties including without limitation, implied warranties or conditions of merchantability,
                    fitness for a particular purpose, or non-infringement of intellectual property or other violation of rights.
                </p>

                <h2 class="text-2xl font-bold text-gray-900 mb-6">8. Limitations</h2>
                <p class="text-gray-600 mb-6">
                    In no event shall {{ $settings->website_name ?? 'CourseSell' }} or its suppliers be liable for any damages
                    (including, without limitation, damages for loss of data or profit, or due to business interruption) arising
                    out of the use or inability to use the materials on {{ $settings->website_name ?? 'CourseSell' }}.
                </p>

                <h2 class="text-2xl font-bold text-gray-900 mb-6">9. Governing Law</h2>
                <p class="text-gray-600 mb-6">
                    These terms and conditions are governed by and construed in accordance with the laws and you irrevocably
                    submit to the exclusive jurisdiction of the courts in that location.
                </p>

                <h2 class="text-2xl font-bold text-gray-900 mb-6">10. Contact Information</h2>
                <p class="text-gray-600 mb-4">
                    If you have any questions about these Terms and Conditions, please contact us:
                </p>
                <div class="bg-gray-50 p-4 rounded-lg mb-6">
                    <p class="text-gray-600"><strong>Email:</strong> {{ $settings->email ?? 'legal@coursesell.com' }}</p>
                    @if($settings->address)
                    <p class="text-gray-600"><strong>Address:</strong> {{ $settings->address }}</p>
                    @endif
                    @if($settings->number)
                    <p class="text-gray-600"><strong>Phone:</strong> {{ $settings->number }}</p>
                    @endif
                </div>
            </div>
        </div>

        <!-- CTA Section -->
        <div class="text-center mt-12">
            <a href="{{ route('contact') }}" class="bg-green-600 hover:bg-green-700 text-white px-8 py-3 rounded-lg font-semibold transition">
                Contact Us
            </a>
        </div>
    </div>
</div>
@endsection
