@extends('themes.coursesell.layout')

@section('content')
<div class="bg-gradient-to-br from-green-50 to-teal-50 py-16">
    <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Hero Section -->
        <div class="text-center mb-16">
            <h1 class="text-5xl font-bold text-gray-900 mb-6">
                Refund Policy
            </h1>
            <p class="text-xl text-gray-600 mb-8">
                Last updated: {{ date('F j, Y') }}
            </p>
        </div>

        <!-- Content -->
        <div class="bg-white rounded-xl shadow-lg p-8">
            <div class="prose prose-lg max-w-none">
                <h2 class="text-2xl font-bold text-gray-900 mb-6">1. Overview</h2>
                <p class="text-gray-600 mb-6">
                    At {{ $settings->website_name ?? 'CourseSell' }}, we strive to ensure complete satisfaction with your enrollment
                    in {{ $settings->website_content_name ?? 'courses' }}. This refund policy outlines the terms and conditions
                    for requesting refunds on our platform.
                </p>

                <h2 class="text-2xl font-bold text-gray-900 mb-6">2. General Refund Policy</h2>
                <p class="text-gray-600 mb-4">
                    Due to the digital nature of our courses, we generally do not offer refunds once an enrollment has been completed.
                    However, we may consider refund requests in the following circumstances:
                </p>
                <ul class="list-disc pl-6 mb-6 text-gray-600">
                    <li>Technical issues preventing course access</li>
                    <li>Course not as described</li>
                    <li>Duplicate enrollments</li>
                    <li>Unauthorized transactions</li>
                    <li>Service unavailability for extended periods</li>
                </ul>

                <h2 class="text-2xl font-bold text-gray-900 mb-6">3. Refund Eligibility</h2>
                <h3 class="text-xl font-semibold text-gray-900 mb-4">Eligible for Refund</h3>
                <ul class="list-disc pl-6 mb-6 text-gray-600">
                    <li>Technical issues within 7 days of enrollment</li>
                    <li>Course defects or malfunctions</li>
                    <li>Incorrect course enrollment</li>
                    <li>Service outages exceeding 24 hours</li>
                </ul>

                <h3 class="text-xl font-semibold text-gray-900 mb-4">Not Eligible for Refund</h3>
                <ul class="list-disc pl-6 mb-6 text-gray-600">
                    <li>Change of mind after enrollment</li>
                    <li>Failure to read course description</li>
                    <li>Compatibility issues with your system</li>
                    <li>Requests made after 7 days of enrollment</li>
                    <li>Courses that have been accessed or viewed</li>
                </ul>

                <h2 class="text-2xl font-bold text-gray-900 mb-6">4. How to Request a Refund</h2>
                <p class="text-gray-600 mb-4">
                    To request a refund, please follow these steps:
                </p>
                <ol class="list-decimal pl-6 mb-6 text-gray-600">
                    <li>Contact our support team within 7 days of enrollment</li>
                    <li>Provide your enrollment number and course details</li>
                    <li>Explain the reason for your refund request</li>
                    <li>Include any relevant screenshots or documentation</li>
                    <li>Wait for our review and response (within 3-5 business days)</li>
                </ol>

                <h2 class="text-2xl font-bold text-gray-900 mb-6">5. Refund Processing</h2>
                <p class="text-gray-600 mb-4">
                    If your refund request is approved:
                </p>
                <ul class="list-disc pl-6 mb-6 text-gray-600">
                    <li>Refunds will be processed within 5-10 business days</li>
                    <li>You will receive a confirmation email</li>
                    <li>The refund will be issued to your original payment method</li>
                    <li>Your course access will be revoked</li>
                </ul>

                <h2 class="text-2xl font-bold text-gray-900 mb-6">6. Partial Refunds</h2>
                <p class="text-gray-600 mb-6">
                    In some cases, we may offer partial refunds for:
                </p>
                <ul class="list-disc pl-6 mb-6 text-gray-600">
                    <li>Course bundles where only one course is defective</li>
                    <li>Subscription services with partial usage</li>
                    <li>Courses with minor issues that don't affect learning</li>
                </ul>

                <h2 class="text-2xl font-bold text-gray-900 mb-6">7. Dispute Resolution</h2>
                <p class="text-gray-600 mb-6">
                    If you disagree with our refund decision, you may:
                </p>
                <ul class="list-disc pl-6 mb-6 text-gray-600">
                    <li>Request a review by our management team</li>
                    <li>Provide additional documentation or evidence</li>
                    <li>Contact your payment provider for assistance</li>
                    <li>Seek mediation through consumer protection agencies</li>
                </ul>

                <h2 class="text-2xl font-bold text-gray-900 mb-6">8. Contact Information</h2>
                <p class="text-gray-600 mb-4">
                    For refund requests or questions about this policy, please contact us:
                </p>
                <div class="bg-gray-50 p-4 rounded-lg mb-6">
                    <p class="text-gray-600"><strong>Email:</strong> {{ $settings->email ?? 'refunds@coursesell.com' }}</p>
                    @if($settings->address)
                    <p class="text-gray-600"><strong>Address:</strong> {{ $settings->address }}</p>
                    @endif
                    @if($settings->number)
                    <p class="text-gray-600"><strong>Phone:</strong> {{ $settings->number }}</p>
                    @endif
                    <p class="text-gray-600"><strong>Response Time:</strong> 3-5 business days</p>
                </div>

                <h2 class="text-2xl font-bold text-gray-900 mb-6">9. Policy Updates</h2>
                <p class="text-gray-600 mb-6">
                    We reserve the right to modify this refund policy at any time. Changes will be effective immediately
                    upon posting on our website. Continued use of our services constitutes acceptance of any policy changes.
                </p>
            </div>
        </div>

        <!-- CTA Section -->
        <div class="text-center mt-12">
            <a href="{{ route('contact') }}" class="bg-green-600 hover:bg-green-700 text-white px-8 py-3 rounded-lg font-semibold transition">
                Contact Support
            </a>
        </div>
    </div>
</div>
@endsection
