@extends('themes.coursesell.layout')

@section('content')
<div class="bg-gradient-to-br from-green-50 to-teal-50 py-16">
    <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Hero Section -->
        <div class="text-center mb-16">
            <h1 class="text-5xl font-bold text-gray-900 mb-6">
                Privacy Policy
            </h1>
            <p class="text-xl text-gray-600 mb-8">
                Last updated: {{ date('F j, Y') }}
            </p>
        </div>

        <!-- Content -->
        <div class="bg-white rounded-xl shadow-lg p-8">
            <div class="prose prose-lg max-w-none">
                <h2 class="text-2xl font-bold text-gray-900 mb-6">1. Introduction</h2>
                <p class="text-gray-600 mb-6">
                    {{ $settings->website_name ?? 'CourseSell' }} ("we," "our," or "us") is committed to protecting your privacy.
                    This Privacy Policy explains how we collect, use, disclose, and safeguard your information when you visit
                    our website and use our {{ $settings->website_content_name ?? 'educational' }} services.
                </p>

                <h2 class="text-2xl font-bold text-gray-900 mb-6">2. Information We Collect</h2>
                <h3 class="text-xl font-semibold text-gray-900 mb-4">Personal Information</h3>
                <p class="text-gray-600 mb-4">
                    We may collect personal information that you voluntarily provide to us when you:
                </p>
                <ul class="list-disc pl-6 mb-6 text-gray-600">
                    <li>Create an account</li>
                    <li>Enroll in {{ $settings->website_content_name ?? 'courses' }}</li>
                    <li>Contact our support team</li>
                    <li>Subscribe to our newsletter</li>
                    <li>Participate in surveys or promotions</li>
                </ul>

                <h3 class="text-xl font-semibold text-gray-900 mb-4">Automatically Collected Information</h3>
                <p class="text-gray-600 mb-6">
                    We automatically collect certain information when you visit our website, including:
                </p>
                <ul class="list-disc pl-6 mb-6 text-gray-600">
                    <li>IP address and location data</li>
                    <li>Browser type and version</li>
                    <li>Operating system</li>
                    <li>Pages visited and time spent</li>
                    <li>Referring website</li>
                </ul>

                <h2 class="text-2xl font-bold text-gray-900 mb-6">3. How We Use Your Information</h2>
                <p class="text-gray-600 mb-4">
                    We use the information we collect to:
                </p>
                <ul class="list-disc pl-6 mb-6 text-gray-600">
                    <li>Provide and maintain our educational services</li>
                    <li>Process enrollments and send confirmations</li>
                    <li>Track your learning progress</li>
                    <li>Send you technical notices and support messages</li>
                    <li>Respond to your comments and questions</li>
                    <li>Improve our website and services</li>
                    <li>Send marketing communications (with your consent)</li>
                </ul>

                <h2 class="text-2xl font-bold text-gray-900 mb-6">4. Information Sharing</h2>
                <p class="text-gray-600 mb-6">
                    We do not sell, trade, or otherwise transfer your personal information to third parties without your consent,
                    except in the following circumstances:
                </p>
                <ul class="list-disc pl-6 mb-6 text-gray-600">
                    <li>To comply with legal obligations</li>
                    <li>To protect our rights and safety</li>
                    <li>With service providers who assist in our operations</li>
                    <li>In connection with a business transfer or merger</li>
                </ul>

                <h2 class="text-2xl font-bold text-gray-900 mb-6">5. Data Security</h2>
                <p class="text-gray-600 mb-6">
                    We implement appropriate security measures to protect your personal information against unauthorized access,
                    alteration, disclosure, or destruction. However, no method of transmission over the internet is 100% secure.
                </p>

                <h2 class="text-2xl font-bold text-gray-900 mb-6">6. Your Rights</h2>
                <p class="text-gray-600 mb-4">
                    You have the right to:
                </p>
                <ul class="list-disc pl-6 mb-6 text-gray-600">
                    <li>Access your personal information</li>
                    <li>Correct inaccurate information</li>
                    <li>Request deletion of your information</li>
                    <li>Opt-out of marketing communications</li>
                    <li>Lodge a complaint with supervisory authorities</li>
                </ul>

                <h2 class="text-2xl font-bold text-gray-900 mb-6">7. Cookies and Tracking</h2>
                <p class="text-gray-600 mb-6">
                    We use cookies and similar tracking technologies to enhance your experience on our website.
                    You can control cookie settings through your browser preferences.
                </p>

                <h2 class="text-2xl font-bold text-gray-900 mb-6">8. Contact Information</h2>
                <p class="text-gray-600 mb-4">
                    If you have questions about this Privacy Policy, please contact us:
                </p>
                <div class="bg-gray-50 p-4 rounded-lg mb-6">
                    <p class="text-gray-600"><strong>Email:</strong> {{ $settings->email ?? 'privacy@coursesell.com' }}</p>
                    @if($settings->address)
                    <p class="text-gray-600"><strong>Address:</strong> {{ $settings->address }}</p>
                    @endif
                    @if($settings->number)
                    <p class="text-gray-600"><strong>Phone:</strong> {{ $settings->number }}</p>
                    @endif
                </div>

                <h2 class="text-2xl font-bold text-gray-900 mb-6">9. Changes to This Policy</h2>
                <p class="text-gray-600 mb-6">
                    We may update this Privacy Policy from time to time. We will notify you of any changes by posting
                    the new Privacy Policy on this page and updating the "Last updated" date.
                </p>
            </div>
        </div>

        <!-- CTA Section -->
        <div class="text-center mt-12">
            <a href="{{ route('contact') }}" class="bg-green-600 hover:bg-green-700 text-white px-8 py-3 rounded-lg font-semibold transition">
                Contact Us
            </a>
        </div>
    </div>
</div>
@endsection
