export type WrapAttributes = "auto" | "force" | "force-aligned" | "force-expand-multiline" | "aligned-multiple" | "preserve" | "preserve-aligned";
export type SortHtmlAttributes = "none" | "alphabetical" | "code-guide" | "idiomatic" | "vuejs" | "custom";
export type EndOfLine = "LF" | "CRLF";
export interface RuntimeConfig {
    indentSize?: number;
    wrapLineLength?: number;
    wrapAttributes?: WrapAttributes;
    wrapAttributesMinAttrs?: number;
    indentInnerHtml?: boolean;
    endWithNewline?: boolean;
    endOfLine?: EndOfLine;
    useTabs?: boolean;
    sortTailwindcssClasses?: boolean;
    tailwindcssConfigPath?: string;
    sortHtmlAttributes?: SortHtmlAttributes;
    customHtmlAttributesOrder?: string[] | string;
    noMultipleEmptyLines?: boolean;
    noPhpSyntaxCheck?: boolean;
    noSingleQuote?: boolean;
    noTrailingCommaPhp?: boolean;
    extraLiners?: string[];
    componentPrefix?: string[];
}
export declare function findRuntimeConfig(filePath: string): string | null;
export declare function readRuntimeConfig(filePath: string | null): Promise<RuntimeConfig | undefined>;
