<?php

namespace Database\Seeders;

use App\Models\Service;
use Illuminate\Database\Seeder;

class ServiceSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $services = [
            [
                'name' => 'Web Development',
                'price' => 999.00,
                'description' => 'Intrinsicly redefine competitive e-business before adaptive potentialiti. Professionally build progressive users with.',
                'order' => 1,
                'is_active' => true,
            ],
            [
                'name' => 'Landing Page',
                'price' => 299.00,
                'description' => 'Intrinsicly redefine competitive e-business before adaptive potentialiti. Professionally build progressive users with.',
                'order' => 2,
                'is_active' => true,
            ],
            [
                'name' => 'Digital Marketing',
                'price' => 599.00,
                'description' => 'Intrinsicly redefine competitive e-business before adaptive potentialiti. Professionally build progressive users with.',
                'order' => 3,
                'is_active' => true,
            ],
            [
                'name' => 'SEO Optimization',
                'price' => 399.00,
                'description' => 'Affordable SEO services by our professionals for generating increased revenue from search while saving valuable time and resources for you.',
                'order' => 4,
                'is_active' => true,
            ],
            [
                'name' => 'Software Services',
                'price' => 1299.00,
                'description' => 'Intrinsicly redefine competitive e-business before adaptive potentialiti. Professionally build progressive users with.',
                'order' => 5,
                'is_active' => true,
            ],
            [
                'name' => 'E-Commerce Solution',
                'price' => 899.00,
                'description' => 'Intrinsicly redefine competitive e-business before adaptive potentialiti. Professionally build progressive users with.',
                'order' => 6,
                'is_active' => true,
            ],
            [
                'name' => 'CRM',
                'price' => 699.00,
                'description' => 'Our CRM system helps you streamline customer interactions, manage sales pipelines, and automate workflows all in one easy-to-use platform.',
                'order' => 7,
                'is_active' => true,
            ],
            [
                'name' => 'Internet Solutions',
                'price' => 799.00,
                'description' => 'Our expertise lies in offering a wide range of services including IP transit, dedicated servers, remote server administration, CDNs, database, video streaming, and domain registration.',
                'order' => 8,
                'is_active' => true,
            ],
            [
                'name' => 'Backup & Recovery',
                'price' => 499.00,
                'description' => 'Intrinsicly redefine competitive e-business before adaptive potentialiti. Professionally build progressive users with.',
                'order' => 9,
                'is_active' => true,
            ],
        ];

        foreach ($services as $service) {
            Service::updateOrCreate(
                ['name' => $service['name']],
                $service
            );
        }

        $this->command->info('Services seeded successfully!');
    }
}
