<?php

namespace App;

enum Theme: string
{
    case DIGIMARKET = 'digimarket';
    case COURSESELL = 'coursesell';
    case DIGIMARKET2 = 'digimarket2';


    public function label(): string
    {
        return match($this) {
            self::DIGIMARKET => 'DigiMarket',
            self::COURSESELL => 'CourseSell',
            self::DIGIMARKET2 => 'DigiMarket 2',
        };
    }

    public function description(): string
    {
        return match($this) {
            self::DIGIMARKET => 'Digital marketplace theme for selling digital products',
            self::COURSESELL => 'Course selling theme for educational content',
            self::DIGIMARKET2 => 'Digital marketplace theme for selling cool digital products',
        };
    }

    public static function options(): array
    {
        return collect(self::cases())->mapWithKeys(function ($theme) {
            return [$theme->value => $theme->label()];
        })->toArray();
    }
}
