<?php

namespace App\Models;

use App\Theme;
use App\Color;
use Illuminate\Database\Eloquent\Model;

class Settings extends Model
{
    protected $table = 'settings';

    protected $fillable = [
        'theme',
        'primary_color',
        'email',
        'number',
        'address',
        'website_name',
        'website_content_name',
    ];

    protected $casts = [
        'theme' => Theme::class,
        'primary_color' => Color::class,
    ];
}
