<?php

namespace App\Http\Controllers;

use App\Models\Settings;
use App\Theme;
use App\Color;
use Illuminate\Http\Request;

class SettingsController extends Controller
{
    public function index()
    {
        $settings = Settings::first();
        $themeOptions = Theme::options();
        return view('settings.index', compact('settings', 'themeOptions'));
    }

    public function update(Request $request)
    {
        $request->validate([
            'theme' => 'nullable|string|in:' . implode(',', array_column(Theme::cases(), 'value')),
            'email' => 'nullable|email|max:255',
            'number' => 'nullable|string|max:255',
            'address' => 'nullable|string',
            'website_name' => 'nullable|string|max:255',
            'website_content_name' => 'nullable|string|max:255',
        ]);

        $settings = Settings::first();

        if (!$settings) {
            $settings = new Settings();
        }

        $settings->fill($request->only([
            'theme',
            'email',
            'number',
            'address',
            'website_name',
            'website_content_name',
        ]));

        $settings->save();

        return redirect()->route('settings.index')->with('success', 'Settings updated successfully!');
    }
}
