<?php

namespace App;

use App\Theme;

enum Color: string
{
    case BLUE = 'blue';
    case GREEN = 'green';
    case PURPLE = 'purple';
    case RED = 'red';
    case ORANGE = 'orange';
    case TEAL = 'teal';
    case PINK = 'pink';
    case INDIGO = 'indigo';

    public function label(): string
    {
        return match($this) {
            self::BLUE => 'Blue',
            self::GREEN => 'Green',
            self::PURPLE => 'Purple',
            self::RED => 'Red',
            self::ORANGE => 'Orange',
            self::TEAL => 'Teal',
            self::PINK => 'Pink',
            self::INDIGO => 'Indigo',
        };
    }

    public function hex(): string
    {
        return match($this) {
            self::BLUE => '#3B82F6',
            self::GREEN => '#10B981',
            self::PURPLE => '#8B5CF6',
            self::RED => '#EF4444',
            self::ORANGE => '#F97316',
            self::TEAL => '#14B8A6',
            self::PINK => '#EC4899',
            self::INDIGO => '#6366F1',
        };
    }

    public function cssClass(): string
    {
        return match($this) {
            self::BLUE => 'blue',
            self::GREEN => 'green',
            self::PURPLE => 'purple',
            self::RED => 'red',
            self::ORANGE => 'orange',
            self::TEAL => 'teal',
            self::PINK => 'pink',
            self::INDIGO => 'indigo',
        };
    }

    public static function optionsForTheme(?Theme $theme = null): array
    {
        // If no theme provided, return empty array
        if (!$theme) {
            return [];
        }

        // Define which colors are available for each theme
        $themeColors = match($theme) {
            Theme::DIGIMARKET => [
                self::BLUE,
                self::GREEN,
                self::PURPLE,
                self::RED,
                self::ORANGE,
                self::TEAL,
                self::PINK,
                self::INDIGO,
            ],
            Theme::COURSESELL => [
                // CourseSell theme doesn't support color customization
            ],
            Theme::DIGIMARKET2 => [
                self::BLUE,
                self::GREEN,
                self::PURPLE,
                self::RED,
                self::ORANGE,
                self::TEAL,
                self::PINK,
                self::INDIGO,
            ],
        };

        return collect($themeColors)->mapWithKeys(function ($color) {
            return [$color->value => $color->label()];
        })->toArray();
    }

    public static function supportsColorCustomization(Theme $theme): bool
    {
        return !empty(self::optionsForTheme($theme));
    }
}
